/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.excavator;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class MineralMix
extends IESerializableRecipe {
    public static RecipeType<MineralMix> TYPE;
    public static RegistryObject<IERecipeSerializer<MineralMix>> SERIALIZER;
    public static final CachedRecipeList<MineralMix> RECIPES;
    public final StackWithChance[] outputs;
    public final int weight;
    public final float failChance;
    public final ImmutableSet<ResourceKey<Level>> dimensions;
    public final Block background;

    public MineralMix(ResourceLocation id, StackWithChance[] outputs, int weight, float failChance, List<ResourceKey<Level>> dimensions, Block background) {
        super((Lazy<ItemStack>)LAZY_EMPTY, TYPE, id);
        this.weight = weight;
        this.failChance = failChance;
        this.outputs = outputs;
        this.dimensions = ImmutableSet.copyOf(dimensions);
        this.background = background;
    }

    protected IERecipeSerializer<MineralMix> getIESerializer() {
        return (IERecipeSerializer)((Object)SERIALIZER.get());
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public String getPlainName() {
        String path = this.m_6423_().m_135815_();
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public String getTranslationKey() {
        return "desc.immersiveengineering.info.mineral." + this.getPlainName();
    }

    public ItemStack getRandomOre(Random rand) {
        float r = rand.nextFloat();
        for (StackWithChance o : this.outputs) {
            if (!(o.chance() >= 0.0f) || !((r -= o.chance()) < 0.0f)) continue;
            return (ItemStack)o.stack().get();
        }
        return ItemStack.f_41583_;
    }

    public boolean validDimension(ResourceKey<Level> dim) {
        if (this.dimensions != null && !this.dimensions.isEmpty()) {
            return this.dimensions.contains(dim);
        }
        return true;
    }

    static {
        RECIPES = new CachedRecipeList<MineralMix>(() -> TYPE, MineralMix.class);
    }
}

